<?php
/*--------------------------------------------------------------
   Factory.php 2021-08-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Data;

use Gambio\Admin\Modules\Statistics\App\Data\Factory\Map as MapFactory;
use Gambio\Admin\Modules\Statistics\App\Data\Factory\Number as NumberFactory;
use Gambio\Admin\Modules\Statistics\App\Data\Factory\Serial as SerialFactory;
use Gambio\Admin\Modules\Statistics\App\Data\Factory\Table as TableFactory;
use Gambio\Admin\Modules\Statistics\App\Data\Factory\Text as TextFactory;
use Gambio\Admin\Modules\Statistics\App\Data\Factory\Timespan as TimespanFactory;

class Factory
{
    /**
     * @var MapFactory
     */
    private $mapFactory;
    
    /**
     * @var SerialFactory
     */
    private $serialFactory;
    
    /**
     * @var TableFactory
     */
    private $tableFactory;
    
    /**
     * @var TextFactory
     */
    private $textFactory;
    
    /**
     * @var NumberFactory
     */
    private $numberFactory;
    
    /**
     * @var TimespanFactory
     */
    private $timespanFactory;
    
    
    /**
     * Constructor.
     */
    public function __construct(
        MapFactory $mapFactory,
        SerialFactory $serialFactory,
        TableFactory $tableFactory,
        TextFactory $textFactory,
        NumberFactory $numberFactory,
        TimespanFactory $timespanFactory
    ) {
        $this->mapFactory      = $mapFactory;
        $this->serialFactory   = $serialFactory;
        $this->tableFactory    = $tableFactory;
        $this->textFactory     = $textFactory;
        $this->numberFactory   = $numberFactory;
        $this->timespanFactory = $timespanFactory;
    }
    
    
    /**
     * Return timespan factory.
     */
    public function useTimespan(): TimespanFactory
    {
        return $this->timespanFactory;
    }
    
    
    /**
     * Return map data factory.
     */
    public function useMapData(): MapFactory
    {
        return $this->mapFactory;
    }
    
    
    /**
     * Return serial data factory.
     */
    public function useSerialData(): SerialFactory
    {
        return $this->serialFactory;
    }
    
    
    /**
     * Return table data factory.
     */
    public function useTableData(): TableFactory
    {
        return $this->tableFactory;
    }
    
    
    /**
     * Return text data factory.
     */
    public function useTextData(): TextFactory
    {
        return $this->textFactory;
    }
    
    
    /**
     * Return number data factory.
     */
    public function useNumberData(): NumberFactory
    {
        return $this->numberFactory;
    }
}